"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const bcrypt = __importStar(require("bcryptjs"));
const user_entity_1 = require("../../entities/user.entity");
const customer_entity_1 = require("../../entities/customer.entity");
const vendor_entity_1 = require("../../entities/vendor.entity");
let AuthService = class AuthService {
    userRepo;
    customerRepo;
    vendorRepo;
    jwtService;
    constructor(userRepo, customerRepo, vendorRepo, jwtService) {
        this.userRepo = userRepo;
        this.customerRepo = customerRepo;
        this.vendorRepo = vendorRepo;
        this.jwtService = jwtService;
    }
    async login(loginDto, requiredRole) {
        try {
            if (!loginDto.email || !loginDto.password) {
                throw new common_1.BadRequestException('Email and password are required');
            }
            const user = await this.userRepo.findOne({
                where: { email: loginDto.email.toLowerCase().trim() }
            });
            if (!user) {
                throw new common_1.UnauthorizedException('Invalid credentials');
            }
            if (!user.isActive) {
                throw new common_1.UnauthorizedException('Account is deactivated');
            }
            if (requiredRole && user.role !== requiredRole) {
                throw new common_1.UnauthorizedException(`This login endpoint is for ${requiredRole}s only. Your account is registered as ${user.role}`);
            }
            const isPasswordValid = await bcrypt.compare(loginDto.password, user.password);
            if (!isPasswordValid) {
                throw new common_1.UnauthorizedException('Invalid credentials');
            }
            const payload = {
                email: user.email,
                sub: user.id,
                role: user.role,
                customerId: user.customerId,
                vendorId: user.vendorId,
            };
            return {
                access_token: this.jwtService.sign(payload),
                user: {
                    id: user.id,
                    email: user.email,
                    role: user.role,
                    customerId: user.customerId,
                    vendorId: user.vendorId,
                },
            };
        }
        catch (error) {
            if (error instanceof common_1.UnauthorizedException || error instanceof common_1.BadRequestException) {
                throw error;
            }
            throw new common_1.InternalServerErrorException('Login failed');
        }
    }
    async register(registerDto) {
        const queryRunner = this.userRepo.manager.connection.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            if (!registerDto.email || !registerDto.password) {
                throw new common_1.BadRequestException('Email and password are required');
            }
            if (registerDto.password.length < 6) {
                throw new common_1.BadRequestException('Password must be at least 6 characters long');
            }
            const email = registerDto.email.toLowerCase().trim();
            const existingUser = await queryRunner.manager.findOne(user_entity_1.User, {
                where: { email }
            });
            if (existingUser) {
                throw new common_1.ConflictException('User with this email already exists');
            }
            const validRoles = ['customer', 'vendor', 'admin'];
            const role = registerDto.role || 'customer';
            if (!validRoles.includes(role)) {
                throw new common_1.BadRequestException('Invalid role');
            }
            if ((role === 'customer' || role === 'vendor') && !registerDto.phone) {
                throw new common_1.BadRequestException('Phone number is required for customer/vendor registration');
            }
            if (registerDto.phone && !this.isValidPhoneNumber(registerDto.phone)) {
                throw new common_1.BadRequestException('Invalid phone number format');
            }
            const hashedPassword = await bcrypt.hash(registerDto.password, 12);
            const user = queryRunner.manager.create(user_entity_1.User, {
                email,
                password: hashedPassword,
                role,
                isActive: true,
            });
            const savedUser = await queryRunner.manager.save(user_entity_1.User, user);
            if (role === 'customer' && registerDto.phone) {
                const existingCustomer = await queryRunner.manager.findOne(customer_entity_1.Customer, {
                    where: { phone: registerDto.phone }
                });
                if (existingCustomer) {
                    throw new common_1.ConflictException('Customer with this phone number already exists');
                }
                const customerName = `${registerDto.firstName || ''} ${registerDto.lastName || ''}`.trim()
                    || registerDto.email.split('@')[0];
                const customer = queryRunner.manager.create(customer_entity_1.Customer, {
                    phone: registerDto.phone,
                    name: customerName,
                    email,
                    address: registerDto.address,
                    userId: savedUser.id,
                    isActive: true,
                });
                const savedCustomer = await queryRunner.manager.save(customer_entity_1.Customer, customer);
                savedUser.customerId = Number(savedCustomer.id);
                await queryRunner.manager.save(user_entity_1.User, savedUser);
            }
            else if (role === 'vendor' && registerDto.phone) {
                const existingVendor = await queryRunner.manager.findOne(vendor_entity_1.Vendor, {
                    where: { phone: registerDto.phone }
                });
                if (existingVendor) {
                    throw new common_1.ConflictException('Vendor with this phone number already exists');
                }
                if (!registerDto.businessName) {
                    throw new common_1.BadRequestException('Business name is required for vendor registration');
                }
                const { v4: uuidv4 } = require('uuid');
                const vendorId = uuidv4();
                const vendor = queryRunner.manager.create(vendor_entity_1.Vendor, {
                    id: vendorId,
                    phone: registerDto.phone,
                    name: registerDto.businessName,
                    email,
                    isApproved: false,
                    userId: savedUser.id,
                    description: registerDto.businessDescription,
                    address: registerDto.address,
                    city: registerDto.city,
                    state: registerDto.state,
                    country: registerDto.country,
                    postalCode: registerDto.postalCode,
                    isActive: true,
                    rating: 0,
                    totalProducts: 0,
                });
                const savedVendor = await queryRunner.manager.save(vendor_entity_1.Vendor, vendor);
                savedUser.vendorId = savedVendor.id;
                await queryRunner.manager.save(user_entity_1.User, savedUser);
            }
            await queryRunner.commitTransaction();
            const payload = {
                email: savedUser.email,
                sub: savedUser.id,
                role: savedUser.role
            };
            return {
                access_token: this.jwtService.sign(payload),
                user: {
                    id: savedUser.id,
                    email: savedUser.email,
                    role: savedUser.role,
                },
            };
        }
        catch (error) {
            await queryRunner.rollbackTransaction();
            if (error instanceof common_1.BadRequestException ||
                error instanceof common_1.ConflictException) {
                throw error;
            }
            throw new common_1.InternalServerErrorException('Registration failed');
        }
        finally {
            await queryRunner.release();
        }
    }
    async changePassword(changePasswordDto, userId) {
        try {
            if (!changePasswordDto.currentPassword ||
                !changePasswordDto.newPassword ||
                !changePasswordDto.confirmNewPassword) {
                throw new common_1.BadRequestException('All password fields are required');
            }
            if (changePasswordDto.newPassword.length < 6) {
                throw new common_1.BadRequestException('New password must be at least 6 characters long');
            }
            if (changePasswordDto.newPassword !== changePasswordDto.confirmNewPassword) {
                throw new common_1.BadRequestException('New passwords do not match');
            }
            if (changePasswordDto.currentPassword === changePasswordDto.newPassword) {
                throw new common_1.BadRequestException('New password must be different from current password');
            }
            const user = await this.userRepo.findOne({
                where: { id: userId }
            });
            if (!user) {
                throw new common_1.UnauthorizedException('User not found');
            }
            const isCurrentPasswordValid = await bcrypt.compare(changePasswordDto.currentPassword, user.password);
            if (!isCurrentPasswordValid) {
                throw new common_1.UnauthorizedException('Current password is incorrect');
            }
            const hashedNewPassword = await bcrypt.hash(changePasswordDto.newPassword, 12);
            user.password = hashedNewPassword;
            user.updatedAt = new Date();
            await this.userRepo.save(user);
            return { message: 'Password changed successfully' };
        }
        catch (error) {
            if (error instanceof common_1.BadRequestException || error instanceof common_1.UnauthorizedException) {
                throw error;
            }
            throw new common_1.InternalServerErrorException('Password change failed');
        }
    }
    async validateUser(email, password) {
        try {
            const user = await this.userRepo.findOne({
                where: { email: email.toLowerCase().trim() }
            });
            if (user &&
                user.isActive &&
                await bcrypt.compare(password, user.password)) {
                const { password: _, ...result } = user;
                return result;
            }
            return null;
        }
        catch (error) {
            return null;
        }
    }
    isValidPhoneNumber(phone) {
        const phoneRegex = /^[\+]?[1-9][\d]{0,15}$/;
        return phoneRegex.test(phone.replace(/\s/g, ''));
    }
    async getUserProfile(userId) {
        try {
            const user = await this.userRepo.findOne({
                where: { id: userId },
                relations: ['customer', 'vendor'],
            });
            if (!user) {
                throw new common_1.UnauthorizedException('User not found');
            }
            return {
                id: user.id,
                email: user.email,
                role: user.role,
                isActive: user.isActive,
                customer: user.customer,
                vendor: user.vendor,
                createdAt: user.createdAt,
                updatedAt: user.updatedAt,
            };
        }
        catch (error) {
            if (error instanceof common_1.UnauthorizedException) {
                throw error;
            }
            throw new common_1.InternalServerErrorException('Failed to fetch user profile');
        }
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(1, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __param(2, (0, typeorm_1.InjectRepository)(vendor_entity_1.Vendor)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        jwt_1.JwtService])
], AuthService);
//# sourceMappingURL=auth.service.js.map